package gov.va.med.mhv.getcare.web.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

/*
 * valid patterns are
 * (443) 289-3469   (999) 999-9999 or (999)999-9999
 * 890.000.8090     999.999.9999
 * 100-100-1000     999-999-9999
 * 123456789012		12 digits
 * 4564646465       10 digits
 * 
 * note: can have leading and trailing spaces
 * in future, if you didn't want that change it to "^{pattern}$" instead of " *{pattern} *"
 */
@FacesValidator(value="PhoneValidator")
public class PhoneValidator implements Validator {
	
	private static final String PATTERN1 = " *\\d{10} *"; // 10 digits
	private static final String PATTERN2  = " *\\d{12} *"; // 12 digits
	private static final String PATTERN3 = " *\\(\\d{3}\\) ?\\d{3}-\\d{4} *"; // (999) 999-9999, space optional
	private static final String PATTERN4 = " *\\d{3}\\.\\d{3}\\.\\d{4} *"; // 999.999.9999
	private static final String PATTERN5 = " *\\d{3}-\\d{3}-\\d{4} *"; // 999-999-9999
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see javax.faces.validator.Validator#validate(javax.faces.context.
	 * FacesContext, javax.faces.component.UIComponent, java.lang.Object)
	 */
	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
		String phone = (String) value;
				
		if (phone == null || phone.isEmpty()) {
			return; // Let required="true" or @NotNull handle it.
		}
		
		if (!phone.matches(PATTERN1) && !phone.matches(PATTERN2) && !phone.matches(PATTERN3) && !phone.matches(PATTERN4) &&  !phone.matches(PATTERN5)) {
			String summary = String.format("'%s' is not a valid phone number.", phone);
			String detail = "Enter a 3 digit area code with a 7 digit phone number.";
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, detail));
		}
	}

}
